function Flink = user_LinkForces(Z,Zd,mbs_data,tsim,ilnk)
% --------------------------
% UCL-CEREM-MBS
%
% @version MBsysLab_m 1.7.a
%
% Creation : 2005
% Last update : 30/09/2008
% -------------------------
%
% Flink = user_LinkForces(Z,Zd,mbs_data,tsim,ilnk)
%
% Z : position of link-body 2 with respect to link-body 1
% Zd : velocity of link-body 2 with respect to link-body 1
% NB :  Z and Zd are automatically computed in the symbolic file
%       associated with the links that the user has introduced in its MBS
% mbs_data : multibody data structure
% tsim : current time
% ilnk : link index (can be obtained via the 'mbs_get_link_id' function)
%
% Flink : force applied to link-body 1 from link-body 2 (link "ilnk")
%   NB :
%     - For a spring/damper system, the Flink force has the SAME sign as Z, Zd
%       (contrary to joint forces) and thus : Flink = + ... Z + ... Zd
%     - The reaction "-Flink" is automatically taken into accounbt by MBsyslab
%
% this function may use a global structure called MBS_user

global MBS_user MBS_info

Flink = 0;

%/*-- Begin of user code --*/
% Use the 'mbs_get_link_id' function to get easily the link indices, e.g. :
% L1 = mbs_get_link_id(MBS_info,'myLink_1');
% [L2,L3] = mbs_get_link_id(MBS_info,'myLink_2','myLink_3');
%

STIFF = mbs_data.user_model.SUSP.K;
DAMP  = mbs_data.user_model.SUSP.C;
Z0    = mbs_data.user_model.SUSP.z0;

Fspring = STIFF(ilnk)*(Z-Z0(ilnk));
Fdamper = DAMP(ilnk)*Zd; % K C Z0

MBS_user.curvar.zd = Zd;

link1_id = mbs_get_link_id(MBS_info,'link1');

switch(ilnk)
    case link1_id
        Flink=Fspring+Fdamper;
        MBS_user.curvar.FSusp=Flink;

        % o_link1 sur barre5
        barre5_id = mbs_get_body_id(MBS_info,'Barre5');
        sens = mbs_gensensor_five_point_suspension_matlab(mbs_data,tsim,[],barre5_id);
        P1_id = mbs_get_bodypoint_id(MBS_info,'Barre5','o_link1');
        P1 = sens.P + sens.R'*mbs_data.dpt(:,P1_id);
        
        % o_link1 sur chassis
        chassis_id = mbs_get_body_id(MBS_info,'Chassis');
        sens = mbs_gensensor_five_point_suspension_matlab(mbs_data,tsim,[],chassis_id);
        P2_id = mbs_get_bodypoint_id(MBS_info,'Chassis','o_link1');
        P2 = sens.P + sens.R'*mbs_data.dpt(:,P2_id);

        MBS_user.curvar.lnk = [Flink Z Zd P1' P2'];
end

%/*-- End of user code --*/

return